<?php	
	//----------------------------------------------------------Connection Database
	include ("api_config.php");
	
	$conn = mysqli_connect($server_name, $server_username, $server_password);
	if (!$conn)
	{
		$conn = NULL;
		//print_operation(false, "Connection Error");
		exit;
	}
		
	$db = mysqli_select_db($conn, $datbase_name);			
	if (!$db) 
	{
		$conn = NULL;
		//print_operation(false, "Database Error");
		exit;
	}
	
	function close_connection()
    {
		global $conn;
		if ($conn != NULL)	
			mysqli_close($conn);
    }
	
	//----------------------------------------------------------function
	
	function execute_sql($sql)
    {
		global $conn;
		try
		{
			$result = mysqli_query($conn, $sql);
			if ($result)
				return true;
			else
				return false;
		}
		catch (Exception $exp) 
		{
			return false;
		}
    }
	
	function get_count($table_name, $where)
    {		
		global $conn;
		$count = 0;
		$sql = " select count(*) as Num from `$table_name` ";
		if ($where != "")
			$sql .= " where " . $where;
		$qry = mysqli_query($conn, $sql);
		if ($row = mysqli_fetch_array($qry)) 
			$count = $row["Num"];
		return $count;
    }
	
	//----------------------------------------------------------Groups Card
	function delete_groups()
    {
		$sql = "delete from `groups`";
		return execute_sql($sql);
    }
	
	function delete_group($GUID)
    {
		$sql = "delete from `groups` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_groups()
    {
		return get_count("groups", "");
    }
	
	function update_group()
    {
		global $Number, $GUID, $Name, $LatinName, $MaterialsCells, $ParentGUID, $IsImage, $IsWaiters, $IsPos, $IsWeight, $IsView, $Ord;
		
		$sql = "delete from `groups` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `groups` 
				 (Number, GUID, Name, LatinName, MaterialsCells, ParentGUID, IsImage, IsWaiters, IsPos, IsWeight, IsView, Ord) 
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $MaterialsCells, '$ParentGUID', $IsImage, $IsWaiters, $IsPos, $IsWeight, $IsView, $Ord) ";
		return execute_sql($sql);
    }
	
	//----------------------------------------------------------Materials Card
	function delete_materials()
    {
		$sql = "delete from `mats`";
		return execute_sql($sql);
    }
	
	function delete_material($GUID)
    {
		$sql = "delete from `mats` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_materials()
    {
		return get_count("mats", "");
    }
	
	function hide_materials($GUID)
    {
		$sql = "update `mats` set IsView = 0 where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function update_material()
    {		
		global $Number, $GUID, $Name, $LatinName, $GroupName, $GroupLatinName, $Notes, $IncQty, $DefUnit, $Unity, $Unit2, $Unit3, $Unit4, $Unit5, 
				  $Barcode, $Barcode2, $Barcode3, $Barcode4, $Barcode5, $Unit2Fact, $Unit3Fact, $Unit4Fact, $Unit5Fact, 
				  $Price, $Price2, $Price3, $Price4, $Price5, $Offer, $Offer2, $Offer3, $Offer4, $Offer5, 
				  $Wholesale, $Wholesale2, $Wholesale3, $Wholesale4, $Wholesale5, 
				  $WholesaleHalf, $WholesaleHalf2, $WholesaleHalf3, $WholesaleHalf4, $WholesaleHalf5, 
				  $Distributor, $Distributor2, $Distributor3, $Distributor4, $Distributor5, $Export, $Export2, $Export3, $Export4, $Export5,
				  $Mafraq, $Mafraq2, $Mafraq3, $Mafraq4, $Mafraq5, $Size, $Qty, $SizeGUID, $ColorGUID,
				  $IsSizeProperties, $IsColorProperties, $GroupGUID, $IsImage, $IsWaiters, $IsPos, $IsWeight, $IsView, $Ord;
		
		$sql = "delete from `mats` where GUID = '$GUID'";			
				execute_sql($sql);			
				
		$sql = " insert into `mats` 
			   (
				  Number, GUID, Name, LatinName, Notes, IncQty, DefUnit, Unity, Unit2, Unit3, Unit4, Unit5, 
				  Barcode, Barcode2, Barcode3, Barcode4, Barcode5, Unit2Fact, Unit3Fact, Unit4Fact, Unit5Fact, 
				  Price, Price2, Price3, Price4, Price5, Offer, Offer2, Offer3, Offer4, Offer5, 
				  Wholesale, Wholesale2, Wholesale3, Wholesale4, Wholesale5, WholesaleHalf, WholesaleHalf2, WholesaleHalf3, WholesaleHalf4, WholesaleHalf5, 
				  Distributor, Distributor2, Distributor3, Distributor4, Distributor5, Export, Export2, Export3, Export4, Export5, 
				  Mafraq, Mafraq2, Mafraq3, Mafraq4, Mafraq5, Size, Qty, SizeGUID, ColorGUID, IsSizeProperties, IsColorProperties, 
				  GroupGUID, IsImage, IsWaiters, IsPos, IsWeight, IsView, Ord
			   ) 
			   values 
			   (
				  $Number, '$GUID', '$Name', '$LatinName', '$Notes', $IncQty, $DefUnit, '$Unity', '$Unit2', '$Unit3', '$Unit4', '$Unit5', 
				  '$Barcode', '$Barcode2', '$Barcode3', '$Barcode4', '$Barcode5', $Unit2Fact, $Unit3Fact, $Unit4Fact, $Unit5Fact, 
				  $Price, $Price2, $Price3, $Price4, $Price5, $Offer, $Offer2, $Offer3, $Offer4, $Offer5, 
				  $Wholesale, $Wholesale2, $Wholesale3, $Wholesale4, $Wholesale5, 
				  $WholesaleHalf, $WholesaleHalf2, $WholesaleHalf3, $WholesaleHalf4, $WholesaleHalf5, 
				  $Distributor, $Distributor2, $Distributor3, $Distributor4, $Distributor5, $Export, $Export2, $Export3, $Export4, $Export5,
				  $Mafraq, $Mafraq2, $Mafraq3, $Mafraq4, $Mafraq5, '$Size', $Qty, '$SizeGUID', '$ColorGUID',
				  '$IsSizeProperties', '$IsColorProperties', '$GroupGUID', $IsImage, $IsWaiters, $IsPos, $IsWeight, $IsView, $Ord
			   )"
			  ;

		return execute_sql($sql);
    }
	
	
	//----------------------------------------------------------Customers Card
	function delete_customers()
    {
		$sql = "delete from `customers`";
		return execute_sql($sql);
    }
	
	function delete_customer($GUID)
    {
		$sql = "delete from `customers` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_customers()
    {
		return get_count("customers", "");
    }
	
	function update_customer()
    {
		global $Number, $GUID, $Name, $LatinName, $IsActive, $Password, $Address, $Address2, $AddyGUID, $Addy2GUID, $Email, 
			    $Phone, $Mobile, $WebSite, $DefPrice, $DefExtra, $Notes, $Fingerprint, $Flag, $City, $City2, $StreetName, $StreetName2,
				$BuildingNumber, $BuildingNumber2, $Postbox, $Postbox2, $PlotIdentification, $PlotIdentification2, $Barcode;
		
		$sql = "delete from `customers` where GUID = '$GUID'";			
		execute_sql($sql);			
			
		$sql = " insert into `customers`
			   (Number, GUID, Name, LatinName, IsActive, Password, Address, Address2, AddyGUID, Addy2GUID, Email, Phone, Mobile, 
				WebSite, DefPrice, DefExtra, Notes, Fingerprint, Flag, City, City2, StreetName, StreetName2, 
				BuildingNumber, BuildingNumber2, Postbox, Postbox2, PlotIdentification, PlotIdentification2, Barcode)
				values
			   ($Number, '$GUID', '$Name', '$LatinName', $IsActive, '$Password', '$Address', '$Address2', '$AddyGUID', '$Addy2GUID', '$Email', 
			   '$Phone', '$Mobile',
				'$WebSite', $DefPrice, $DefExtra, '$Notes', '$Fingerprint', '$Flag', '$City', '$City2', '$StreetName', '$StreetName2',
				'$BuildingNumber', '$BuildingNumber2', '$Postbox', '$Postbox2', '$PlotIdentification', '$PlotIdentification2', '$Barcode') ";
		return execute_sql($sql);
    }
	
	
	
	
	function update_customers()
    {
		global $Number_List,$GUID_List,$Name_List, $LatinName_List, $IsActive_List, $Password_List, $Address_List,
				$Address2_List, $AddyGUID_List, $Addy2GUID_List, $Email_List, $Phone_List, $Mobile_List, $WebSite_List,
				$DefPrice_List, $DefExtra_List, $Notes_List, $Fingerprint_List, $Flag_List, $City_List, $City2_List,
				$StreetName_List, $StreetName2_List, $BuildingNumber_List, $BuildingNumber2_List, $Postbox_List,
				$Postbox2_List, $PlotIdentification_List, $PlotIdentification2_List, $Barcode_List;
		
		
		$sql_delete = "";
		$sql_insert = " insert into `customers`
					   (Number, GUID, Name, LatinName, IsActive, Password, Address, Address2, AddyGUID, Addy2GUID, Email, Phone, Mobile, 
						WebSite, DefPrice, DefExtra, Notes, Fingerprint, Flag, City, City2, StreetName, StreetName2, 
						BuildingNumber, BuildingNumber2, Postbox, Postbox2, PlotIdentification, PlotIdentification2, Barcode)
						values ";
		for ($i=0; $i < count($Number_List); $i++)
		{
			$Number = $Number_List[$i];
			$GUID = $GUID_List[$i];
			$Name = $Name_List[$i];
			$LatinName = $LatinName_List[$i];
			$IsActive = $IsActive_List[$i];
			$Password = $Password_List[$i];
			$Address = $Address_List[$i];
			$Address2 = $Address2_List[$i];
			$AddyGUID = $AddyGUID_List[$i];
			$Addy2GUID = $Addy2GUID_List[$i];
			$Email = $Email_List[$i];
			$Phone = $Phone_List[$i];
			$Mobile = $Mobile_List[$i];
			$WebSite = $WebSite_List[$i];
			$DefPrice = $DefPrice_List[$i];
			$DefExtra = $DefExtra_List[$i];
			$Notes = $Notes_List[$i];
			$Fingerprint = $Fingerprint_List[$i];
			$Flag = $Flag_List[$i];
			$City = $City_List[$i];
			$City2 = $City2_List[$i];
			$StreetName = $StreetName_List[$i];
			$StreetName2 = $StreetName2_List[$i];
			$BuildingNumber = $BuildingNumber_List[$i];
			$BuildingNumber2 = $BuildingNumber2_List[$i];
			$Postbox = $Postbox_List[$i];
			$Postbox2 = $Postbox2_List[$i];
			$PlotIdentification = $PlotIdentification_List[$i];
			$PlotIdentification2 = $PlotIdentification2_List[$i];
			$Barcode = $Barcode_List[$i];
			
			
			
			$sql_delete .= "delete from `customers` where GUID = '$GUID'" . ";";

			if ($i > 0)
				$sql_insert .= ", ";
				
			$sql_insert .= " ($Number, '$GUID', '$Name', '$LatinName', $IsActive, '$Password', '$Address', '$Address2', '$AddyGUID', '$Addy2GUID', '$Email', 
							'$Phone', '$Mobile',
							'$WebSite', $DefPrice, $DefExtra, '$Notes', '$Fingerprint', '$Flag', '$City', '$City2', '$StreetName', '$StreetName2',
							'$BuildingNumber', '$BuildingNumber2', '$Postbox', '$Postbox2', '$PlotIdentification', '$PlotIdentification2', '$Barcode') ";
		}
		
		if ($sql_delete != "")
		{
			execute_sql($sql_delete);
			return execute_sql($sql_insert);			
		}
		
		return false;		
    }
	
	
	
	//----------------------------------------------------------Showrooms Card (Restaurant)
	function delete_showrooms()
    {
		$sql = "delete from `showrooms`";
		return execute_sql($sql);
    }
	
	function delete_showroom($GUID)
    {
		$sql = "delete from `showrooms` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_showrooms()
    {
		return get_count("showrooms", "");
    }
	
	function update_showroom()
    {
		global $Number, $GUID, $Name, $LatinName, $Color, $ParentGUID, $IsView, $Ord;
		
		$sql = "delete from `showrooms` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `showrooms` 
				 (Number, GUID, Name, LatinName, Color, ParentGUID, IsView, Ord)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $Color, '$ParentGUID', $IsView, $Ord)";
		return execute_sql($sql);	 
		
    }
	
	
	//----------------------------------------------------------Tables Card
	function delete_tables()
    {
		$sql = "delete from `tables`";
		return execute_sql($sql);
    }
	
	function delete_table($GUID)
    {
		$sql = "delete from `tables` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_tables()
    {
		return get_count("tables", "");
    }
	
	function update_table()
    {
		global $Number, $GUID, $Name, $LatinName, $Persons, $ShowroomGUID, $IsView, $Ord;
		
		$sql = "delete from `tables` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `tables` 
				 (Number, GUID, Name, LatinName, Persons, ShowroomGUID, IsView, Ord)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $Persons, '$ShowroomGUID', $IsView, $Ord)";
		return execute_sql($sql);
    }
	
	
	
	
	//----------------------------------------------------------Gallery Card
	function delete_galleries()
    {
		$sql = "delete from `gallery`";
		return execute_sql($sql);
    }
	
	function delete_gallery($GUID)
    {
		$sql = "delete from `gallery` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_galleries()
    {
		return get_count("gallery", "");
    }
	
	function update_gallery()
    {
		global $Number, $GUID, $Name, $LatinName, $GroupGUID, $MaterialGUID, $IsView, $IsImage, $Ord;
		
		$sql = "delete from `gallery` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `gallery` 
				 (Number, GUID, Name, LatinName, GroupGUID, MaterialGUID, IsView, IsImage, Ord)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', '$GroupGUID', '$MaterialGUID', $IsView, $IsImage, $Ord)";
		return execute_sql($sql);
    }
	
	
	
	
	//----------------------------------------------------------Regions Card
	function delete_regions()
    {
		$sql = "delete from `addy`";
		return execute_sql($sql);
    }
	
	function delete_region($GUID)
    {
		$sql = "delete from `addy` where GUID = '$GUID'";			
		return execute_sql($sql);
    }
	
	function count_regions()
    {
		return get_count("addy", "");
    }
	
	function update_region()
    {
		global $Number, $GUID, $Name, $LatinName, $Shipping, $MinimumOrder, $ParentGUID, $IsView, $Ord;
		
		$sql = "delete from `addy` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `addy` 
				 (Number, GUID, Name, LatinName, Shipping, MinimumOrder, ParentGUID, IsView, Ord)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $Shipping, $MinimumOrder, '$ParentGUID', $IsView, $Ord)";
		return execute_sql($sql);
    }
	
	
	
	
	//----------------------------------------------------------Additional material barcode
	function delete_barcodes()
    {
		$sql = "delete from `barcodemat`";
		return execute_sql($sql);
    }
	
	function count_barcodes()
    {
		return get_count("barcodemat", "");
    }
	
	function update_barcode()
    {
		global $GUID, $MaterialGUID, $DefUnit, $Barcode, $Price;
		
		$sql = "delete from `barcodemat` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `barcodemat` 
				 (GUID, MaterialGUID, DefUnit, Barcode, Price)
				 values 
				 ('$GUID', '$MaterialGUID', $DefUnit, '$Barcode', $Price)";
		return execute_sql($sql);
    }
	
	
	
	
	
	//----------------------------------------------------------Materials Offers
	function delete_offers()
    {
		$sql = "delete from `offers`";
		return execute_sql($sql);
    }
	
	function count_offers()
    {
		return get_count("offers", "");
    }
	
	function update_offer()
    {
		global $Number, $GUID, $MaterialGUID, $Price;
		
		$sql = "delete from `offers` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `offers` 
				 (Number, GUID, MaterialGUID, Price)
				 values 
				 ($Number, '$GUID', '$MaterialGUID', $Price)";
		return execute_sql($sql);
    }
	
	
	
	
	
	//----------------------------------------------------------Properties Cards (Size, Color)
	function delete_properties()
    {
		$sql = "delete from `propertyitems`";
		execute_sql($sq);
		$sql = "delete from `property`";
		return execute_sql($sql);
    }
	
	function delete_properties_inventory()
    {
		$sql = "delete from `propertiesinventory`";
		return execute_sql($sql);
    }
	
	function count_properties()
    {
		return get_count("property", "");//GUID in (select ParentGUID from `propertyitems`)
    }
	
	function update_property()
    {
		global $Number, $GUID, $Name, $LatinName, $IsImage, $IsView;
		
		$sql = "delete from `propertyitems` where ParentGUID = '$GUID'";			
		execute_sql($sql);	
		
		$sql = "delete from `property` where GUID = '$GUID'";			
		execute_sql($sql);			
		
		$sql = " insert into `property` 
				 (Number, GUID, Name, LatinName, IsImage, IsView)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $IsImage, $IsView)";
		return execute_sql($sql);
    }
	
	function update_property_items()
    {
		global $Number, $GUID, $Name, $LatinName, $Color, $Notes, $ParentGUID;
		
		$sql = " insert into `propertyitems` 
				 (Number, GUID, Name, LatinName, Color, Notes, ParentGUID)
				 values 
				 ($Number, '$GUID', '$Name', '$LatinName', $Color, '$Notes', '$ParentGUID')";
		return execute_sql($sql);
    }
	
	function update_property_inventory()
    {
		global $GUID, $MaterialGUID, $Size, $Color, $Qty;
		
		$sql = " insert into `propertiesinventory` 
				 (GUID, MaterialGUID, Size, Color, Qty)
				 values 
				 ('$GUID', '$MaterialGUID', '$Size', '$Color', $Qty)";
		return execute_sql($sql);
    }
	
	
	//----------------------------------------------------------Options
	function delete_options()
    {
		$sql = "delete from `options`";
		return execute_sql($sql);
    }
	
	function count_options()
    {
		return get_count("options", "");
    }
	
	function update_option()
    {
		global $KeyName, $Name;
		
		$sql = "delete from `options` where KeyName = '$KeyName'";			
		execute_sql($sql);			
		
		$sql = " insert into `options` 
				 (KeyName, Name)
				 values 
				 ('$KeyName', '$Name')";
		return execute_sql($sql);
    }
	
	
	
	
	//----------------------------------------------------------Get a list of new customer records
	function delete_registers()
    {
		$sql = "delete from `register`";
		return execute_sql($sql);
    }
	
	function delete_register($ID)
    {		
		$sql = "delete from `register` where ID = $ID";			
		return execute_sql($sql);
    }
	
	function get_registers($addy_guid)
    {
		global $conn;
		
		$where = "where (1 = 1) ";
		if ($addy_guid != "")
		{
			$where .= " and
						(AddyGUID in ($addy_guid) or Addy2GUID in ($addy_guid))
					  	 or
						 (AddyGUID = '00000000-0000-0000-0000-000000000000' and Addy2GUID = '00000000-0000-0000-0000-000000000000')
				      ";
		}
		
		$sql = " select * from `register` ";
		$sql .= $where;
		$sql .= " Order by ID ";
		$index = 0;
		$qry = mysqli_query($conn, $sql);
		while ($row = mysqli_fetch_array($qry)) 
		{
			$ID =  $row["ID"];
			$GUID =  $row["GUID"];
			$Name = $row["FirstName"] . " " . $row["LastName"];
			$Password = $row["Password"];
			$Address1 = $row["Address"];
			$Address2 = $row["Address2"];
			$AddyGUID = $row["AddyGUID"];
			$Addy2GUID =  $row["Addy2GUID"];
			$Email = $row["Email"];
			$Phone = $row["Phone"];
			$Mobile = $row["Mobile"];
			$Latitude = $row["Latitude"];
			$Longitude = $row["Longitude"];
			$Fingerprint = $row["Fingerprint"];
			$IndexUpdate = $row["IndexUpdate"];
			$City = $row["City"];
			$City2 = $row["City2"];
			$StreetName = $row["StreetName"];
			$StreetName2 = $row["StreetName2"];
			$BuildingNumber = $row["BuildingNumber"];
			$BuildingNumber2 = $row["BuildingNumber2"];
			$Postbox = $row["Postbox"];
			$Postbox2 = $row["Postbox2"];
			$PlotIdentification = $row["PlotIdentification"];
			$PlotIdentification2 = $row["PlotIdentification2"];
			$Barcode = $row["Barcode"];
			
			if ($Latitude == "")
				$Latitude = "0";
			if ($Longitude == "")
				$Longitude = "0";
			
			$info = array(  "ID" => $ID, 
						"GUID" => $GUID, 
						"Name" => $Name, 
						"Password" => $Password, 
						"Address1" => $Address1, 
						"Address2" => $Address2, 
						"AddyGUID" => $AddyGUID, 
						"Addy2GUID" => $Addy2GUID, 
						"Email" => $Email, 
						"Phone" => $Phone, 
						"Mobile" => $Mobile, 
						"Latitude" => $Latitude, 
						"Longitude" => $Longitude, 
						"Fingerprint" => $Fingerprint, 
						"IndexUpdate" => $IndexUpdate, 
						"City" => $City, 
						"City2" => $City2, 
						"StreetName" => $StreetName, 
						"StreetName2" => $StreetName2, 
						"BuildingNumber" => $BuildingNumber, 
						"BuildingNumber2" => $BuildingNumber2, 
						"Postbox" => $Postbox, 
						"Postbox2" => $Postbox2, 
						"PlotIdentification" => $PlotIdentification, 
						"PlotIdentification2" => $PlotIdentification2,
						"Barcode" => $Barcode);
						
					
			$list[$index] = $info;	
			$index++;			
		}
		
		return $list;
    }
	
	
	
	
	//----------------------------------------------------------Operations (Delete Card Customer ID = 0)
	function delete_operations()
    {
		$sql = "delete from `operations`";
		return execute_sql($sql);
    }
	
	function delete_operation($GUID, $ID)
    {
		$sql = "delete from `operations` where ID = $ID and GUID = '$GUID";			
		return execute_sql($sql);
    }	
	
	function get_operations()
    {
		global $conn;
		$sql = " select GUID, ID from `operations` ";				
		$index = 0;
		$qry = mysqli_query($conn, $sql);
		while ($row = mysqli_fetch_array($qry)) 
		{
			$ID =  $row["ID"];
			$GUID = $row["GUID"];
			
			$info = array("ID" => $ID, 
						"GUID" => $GUID);
					
			$list[$index] = $info;	
			$index++;			
		}
		if ($index == 0)
			return NULL;
		else
			return $list;			
    }
	
	
	
	//----------------------------------------------------------Notification : Check New Register
	function get_notification_registers($addy_guid)
    {
		$where = "";
		if ($addy_guid != "")
		{
			$where .= "  (AddyGUID in ($addy_guid) or Addy2GUID in ($addy_guid))
					  	 or
						 (AddyGUID = '00000000-0000-0000-0000-000000000000' and Addy2GUID = '00000000-0000-0000-0000-000000000000')
				      ";
		}
		return get_count("register", $where);
    }
	
	function get_notification_orders($addy_guid)
    {
		$where = " IsEnable = 1 and IsRecycleBin = 0 ";
		
		if ($addy_guid != "")
		{
			$where .= " and CustGUID in 
					  (
					  	select GUID from customers 
					  	where (AddyGUID in ($addy_guid) or Addy2GUID in ($addy_guid))
					  	or (AddyGUID = '00000000-0000-0000-0000-000000000000' and Addy2GUID = '00000000-0000-0000-0000-000000000000')
					  )";
		}
		
		return get_count("orders", $where);	
    }
	
	
	
	
	
	//----------------------------------------------------------Orders
	function delete_orders()
    {
		$sql = "delete from `orderitems`";
		execute_sql($sql);
		$sql = "delete from `orders`";
		return execute_sql($sql);
    }
	
	function delete_order($ID)
    {
		$sql = "update `orders` set IsRecycleBin = 1 where ID = $ID";
		return execute_sql($sql);
    }
	
	
	function get_orders($addy_guid)
    {
		global $conn;
		
		$sql = " select * from orders ";
		$sql .= " where IsEnable = 1 and IsRecycleBin = 0 ";
		
		if ($addy_guid != "")
		{
			$sql .= " and CustGUID in 
					  (
					  	select GUID from customers 
					  	where (AddyGUID in ($addy_guid) or Addy2GUID in ($addy_guid))
					  	or (AddyGUID = '00000000-0000-0000-0000-000000000000' and Addy2GUID = '00000000-0000-0000-0000-000000000000')
					  )";
		}
		
		$sql .= " Order by ID ";
				
		$array_id = "";
		$index_order = 0;
		$qry = mysqli_query($conn, $sql);
		while ($row = mysqli_fetch_array($qry)) 
		{
			$ID =  $row["ID"];
			$CustGUID =  $row["CustGUID"];
			$TableGUID =  $row["TableGUID"];
			$PayType =  $row["PayType"];
			$TypeBill =  $row["TypeBill"];
			$BillGUID =  $row["BillGUID"];
			$Date =  $row["Date"];
			$Notes =  $row["Notes"];
			$AddressID =  $row["AddressID"];
			$AddressOrder =  "";//New Address
			$AddressGUID =  "";//New Region
			
			$info = array(  "ID" => $ID, 
						"CustGUID" => $CustGUID, 
						"TableGUID" => $TableGUID, 
						"PayType" => $PayType, 
						"TypeBill" => $TypeBill, 
						"BillGUID" => $BillGUID, 
						"Date" => $Date, 
						"Notes" => $Notes, 
						"AddressID" => $AddressID, 
						"AddressOrder" => $AddressOrder, 
						"AddressGUID" => $AddressGUID);
			$orders[$index_order] = $info;
			if ($index_order == 0)
				$array_id .= $ID;
			else
				$array_id .= "," . $ID;		
			$index_order++;			
		}
		
		
		if ($array_id != "")
		{
			$sql = " select * from orderitems where OrderID in ($array_id) Order by ID ";				
			$index_item = 0;
			$qry = mysqli_query($conn, $sql);
			while ($row = mysqli_fetch_array($qry)) 
			{
				$OrderID =  $row["OrderID"];
				$MatGUID =  $row["MatGUID"];
				$Qty =  $row["Qty"];
				$Price =  $row["Price"];
				$Unity =  $row["Unity"];
				$Size =  $row["Size"];
				$Color =  $row["Color"];
				$Notes =  $row["Notes"];
				
				$info = array("OrderID" => $OrderID, 
							"MatGUID" => $MatGUID, 
							"Qty" => $Qty, 
							"Price" => $Price, 
							"Unity" => $Unity, 
							"Size" => $Size, 
							"Color" => $Color, 
							"Notes" => $Notes);
							
				$items[$index_item] = $info;	
				$index_item++;			
			}
		}
				
		return array($index_order, $orders, $items);
    }
	
	
	//----------------------------------------------------------State Bills
	function delete_state_bills()
    {
		$sql = "delete from `statebill`";
		return execute_sql($sql);
    }
	
	function update_state_bill()
    {
		global $BillGUID, $State, $NumberDay, $Notes, $IsAttachBill;
			
		if (get_count("statebill", "BillGUID = '$BillGUID'") == 0)
		{
			$sql = "insert into statebill
					 (BillGUID, State)
					 values
					 ('$BillGUID', $State)";	 
		}
		else
		{
			$sql = " update statebill set ";
			if ($State != 0)
				$sql .= " State = $State ";
			else
				$sql .= " State = State ";
			if ($NumberDay != 0)
				$sql .= ", NumberDay = $NumberDay ";
			if ($Notes != "")
				$sql .= ", Notes = '$Notes' ";
			if ($IsAttachBill == 1)
				$sql .= ", IsAttachBill = $IsAttachBill ";
			$sql .= " where BillGUID = '$BillGUID'";	 
		}
		return execute_sql($sql);	
    }
	
	
	function close_state_bills($BillGUID)
    {			
		$sql = " update statebill set State = 4, Notes = '' where State <> -1 and BillGUID in ($BillGUID)";
		return execute_sql($sql);	
    }
	
	
	//----------------------------------------------------------Test 
	function test_values()
    {		
		global $conn;
		$sql = " select * from options limit 1 ";	
		$qry = mysqli_query($conn, $sql);
		if ($row = mysqli_fetch_array($qry)) 
			return $row["KeyName"] . ": " . $row["Name"];
		else
			return $row["KeyName"] . ": " . $row["Name"];	
    }
	
	
	//----------------------------------------------------------Factory Reset - Delete All Tables
	function reset_factory()
    {
		$sql = "delete from gallery";
		execute_sql($sql);
		$sql = "delete from `groups`";
		execute_sql($sql);
		$sql = "delete from `mats`";
		execute_sql($sql);
		$sql = "delete from `branches`";
		execute_sql($sql);
		$sql = "delete from `orderitems`";
		execute_sql($sql);
		$sql = "delete from `orders`";
		execute_sql($sql);
		$sql = "delete from `register`";
		execute_sql($sql);
		$sql = "delete from `requests`";
		execute_sql($sql);
		$sql = "delete from `customers`";
		execute_sql($sql);
		$sql = "delete from `offers`";
		execute_sql($sql);
		$sql = "delete from `property`";
		execute_sql($sql);
		$sql = "delete from `propertyitems`";
		execute_sql($sql);
		$sql = "delete from `tables`";
		execute_sql($sql);
		$sql = "delete from `showrooms`";
		execute_sql($sql);
		$sql = "delete from `addy`";
		execute_sql($sql);
		$sql = "delete from `payments`";
		execute_sql($sql);
		$sql = "delete from `options`";
		execute_sql($sql);
		$sql = "delete from `last_order`";
		execute_sql($sql);
		$sql = "delete from `last_orderitems`";
		execute_sql($sql);
		$sql = "delete from `operations`";
		return execute_sql($sql);
    }
	
	
?>